package io.burkard.cdk.services.iottwinmaker.cfnEntity

import scala.collection.JavaConverters._

@scala.annotation.nowarn("cat=deprecation")
@SuppressWarnings(Array("org.wartremover.warts.DefaultArguments", "org.wartremover.warts.Null", "DisableSyntax.null"))
object DataValueProperty {

  def apply(
    doubleValue: Option[Number] = None,
    integerValue: Option[Number] = None,
    mapValue: Option[Map[String, _]] = None,
    longValue: Option[Number] = None,
    stringValue: Option[String] = None,
    expression: Option[String] = None,
    relationshipValue: Option[AnyRef] = None,
    listValue: Option[List[_]] = None,
    booleanValue: Option[Boolean] = None
  ): software.amazon.awscdk.services.iottwinmaker.CfnEntity.DataValueProperty =
    (new software.amazon.awscdk.services.iottwinmaker.CfnEntity.DataValueProperty.Builder)
      .doubleValue(doubleValue.orNull)
      .integerValue(integerValue.orNull)
      .mapValue(mapValue.map(_.asJava).orNull)
      .longValue(longValue.orNull)
      .stringValue(stringValue.orNull)
      .expression(expression.orNull)
      .relationshipValue(relationshipValue.orNull)
      .listValue(listValue.map(_.asJava).orNull)
      .booleanValue(booleanValue.map(Boolean.box).orNull)
      .build()
}
