package io.burkard.cdk.services.iottwinmaker.cfnEntity

import scala.collection.JavaConverters._

@scala.annotation.nowarn("cat=deprecation")
@SuppressWarnings(Array("org.wartremover.warts.DefaultArguments", "org.wartremover.warts.Null", "DisableSyntax.null"))
object ComponentProperty {

  def apply(
    description: Option[String] = None,
    componentName: Option[String] = None,
    properties: Option[Map[String, _]] = None,
    status: Option[software.amazon.awscdk.services.iottwinmaker.CfnEntity.StatusProperty] = None,
    componentTypeId: Option[String] = None,
    definedIn: Option[String] = None
  ): software.amazon.awscdk.services.iottwinmaker.CfnEntity.ComponentProperty =
    (new software.amazon.awscdk.services.iottwinmaker.CfnEntity.ComponentProperty.Builder)
      .description(description.orNull)
      .componentName(componentName.orNull)
      .properties(properties.map(_.asJava).orNull)
      .status(status.orNull)
      .componentTypeId(componentTypeId.orNull)
      .definedIn(definedIn.orNull)
      .build()
}
