package io.burkard.cdk.services.iotevents.cfnDetectorModel

import scala.collection.JavaConverters._

@scala.annotation.nowarn("cat=deprecation")
@SuppressWarnings(Array("org.wartremover.warts.DefaultArguments", "org.wartremover.warts.Null", "DisableSyntax.null"))
object TransitionEventProperty {

  def apply(
    condition: String,
    nextState: String,
    eventName: String,
    actions: Option[List[_]] = None
  ): software.amazon.awscdk.services.iotevents.CfnDetectorModel.TransitionEventProperty =
    (new software.amazon.awscdk.services.iotevents.CfnDetectorModel.TransitionEventProperty.Builder)
      .condition(condition)
      .nextState(nextState)
      .eventName(eventName)
      .actions(actions.map(_.asJava).orNull)
      .build()
}
