package io.burkard.cdk.services.imagebuilder.cfnDistributionConfiguration

@SuppressWarnings(Array("org.wartremover.warts.DefaultArguments", "org.wartremover.warts.Null", "DisableSyntax.null"))
object FastLaunchConfigurationProperty {

  def apply(
    enabled: Option[Boolean] = None,
    launchTemplate: Option[software.amazon.awscdk.services.imagebuilder.CfnDistributionConfiguration.FastLaunchLaunchTemplateSpecificationProperty] = None,
    accountId: Option[String] = None,
    snapshotConfiguration: Option[software.amazon.awscdk.services.imagebuilder.CfnDistributionConfiguration.FastLaunchSnapshotConfigurationProperty] = None,
    maxParallelLaunches: Option[Number] = None
  ): software.amazon.awscdk.services.imagebuilder.CfnDistributionConfiguration.FastLaunchConfigurationProperty =
    (new software.amazon.awscdk.services.imagebuilder.CfnDistributionConfiguration.FastLaunchConfigurationProperty.Builder)
      .enabled(enabled.map(Boolean.box).orNull)
      .launchTemplate(launchTemplate.orNull)
      .accountId(accountId.orNull)
      .snapshotConfiguration(snapshotConfiguration.orNull)
      .maxParallelLaunches(maxParallelLaunches.orNull)
      .build()
}
