package io.burkard.cdk.services.guardduty.cfnFilter

import scala.collection.JavaConverters._

@scala.annotation.nowarn("cat=deprecation")
@SuppressWarnings(Array("org.wartremover.warts.DefaultArguments", "org.wartremover.warts.Null", "DisableSyntax.null"))
object ConditionProperty {

  def apply(
    gte: Option[Number] = None,
    lessThan: Option[Number] = None,
    greaterThan: Option[Number] = None,
    greaterThanOrEqual: Option[Number] = None,
    lessThanOrEqual: Option[Number] = None,
    lte: Option[Number] = None,
    equalTo: Option[List[String]] = None,
    lt: Option[Number] = None,
    gt: Option[Number] = None,
    eq: Option[List[String]] = None,
    neq: Option[List[String]] = None,
    notEquals: Option[List[String]] = None
  ): software.amazon.awscdk.services.guardduty.CfnFilter.ConditionProperty =
    (new software.amazon.awscdk.services.guardduty.CfnFilter.ConditionProperty.Builder)
      .gte(gte.orNull)
      .lessThan(lessThan.orNull)
      .greaterThan(greaterThan.orNull)
      .greaterThanOrEqual(greaterThanOrEqual.orNull)
      .lessThanOrEqual(lessThanOrEqual.orNull)
      .lte(lte.orNull)
      .equalTo(equalTo.map(_.asJava).orNull)
      .lt(lt.orNull)
      .gt(gt.orNull)
      .eq(eq.map(_.asJava).orNull)
      .neq(neq.map(_.asJava).orNull)
      .notEquals(notEquals.map(_.asJava).orNull)
      .build()
}
