package io.burkard.cdk.services.gamelift

import scala.collection.JavaConverters._

@scala.annotation.nowarn("cat=deprecation")
@SuppressWarnings(Array("org.wartremover.warts.DefaultArguments", "org.wartremover.warts.Null", "DisableSyntax.null"))
object CfnMatchmakingRuleSetProps {

  def apply(
    name: String,
    ruleSetBody: String,
    tags: Option[List[_ <: software.amazon.awscdk.CfnTag]] = None
  ): software.amazon.awscdk.services.gamelift.CfnMatchmakingRuleSetProps =
    (new software.amazon.awscdk.services.gamelift.CfnMatchmakingRuleSetProps.Builder)
      .name(name)
      .ruleSetBody(ruleSetBody)
      .tags(tags.map(_.asJava).orNull)
      .build()
}
