package io.burkard.cdk.services.gamelift

import scala.collection.JavaConverters._

@scala.annotation.nowarn("cat=deprecation")
@SuppressWarnings(Array("org.wartremover.warts.DefaultArguments", "org.wartremover.warts.Null", "DisableSyntax.null"))
object CfnMatchmakingRuleSet {

  def apply(
    internalResourceId: String,
    name: String,
    ruleSetBody: String,
    tags: Option[List[_ <: software.amazon.awscdk.CfnTag]] = None
  )(implicit stackCtx: software.amazon.awscdk.Stack): software.amazon.awscdk.services.gamelift.CfnMatchmakingRuleSet =
    software.amazon.awscdk.services.gamelift.CfnMatchmakingRuleSet.Builder
      .create(stackCtx, internalResourceId)
      .name(name)
      .ruleSetBody(ruleSetBody)
      .tags(tags.map(_.asJava).orNull)
      .build()
}
