package io.burkard.cdk.services.evidently

import scala.collection.JavaConverters._

@scala.annotation.nowarn("cat=deprecation")
@SuppressWarnings(Array("org.wartremover.warts.DefaultArguments", "org.wartremover.warts.Null", "DisableSyntax.null"))
object CfnExperimentProps {

  def apply(
    name: String,
    project: String,
    metricGoals: List[_],
    treatments: List[_],
    onlineAbConfig: software.amazon.awscdk.services.evidently.CfnExperiment.OnlineAbConfigObjectProperty,
    samplingRate: Option[Number] = None,
    description: Option[String] = None,
    tags: Option[List[_ <: software.amazon.awscdk.CfnTag]] = None,
    runningStatus: Option[software.amazon.awscdk.services.evidently.CfnExperiment.RunningStatusObjectProperty] = None,
    randomizationSalt: Option[String] = None
  ): software.amazon.awscdk.services.evidently.CfnExperimentProps =
    (new software.amazon.awscdk.services.evidently.CfnExperimentProps.Builder)
      .name(name)
      .project(project)
      .metricGoals(metricGoals.asJava)
      .treatments(treatments.asJava)
      .onlineAbConfig(onlineAbConfig)
      .samplingRate(samplingRate.orNull)
      .description(description.orNull)
      .tags(tags.map(_.asJava).orNull)
      .runningStatus(runningStatus.orNull)
      .randomizationSalt(randomizationSalt.orNull)
      .build()
}
