package io.burkard.cdk.services.elasticloadbalancingv2.cfnListenerRule

import scala.collection.JavaConverters._

@scala.annotation.nowarn("cat=deprecation")
@SuppressWarnings(Array("org.wartremover.warts.DefaultArguments", "org.wartremover.warts.Null", "DisableSyntax.null"))
object AuthenticateOidcConfigProperty {

  def apply(
    clientId: String,
    issuer: String,
    authorizationEndpoint: String,
    clientSecret: String,
    userInfoEndpoint: String,
    tokenEndpoint: String,
    useExistingClientSecret: Option[Boolean] = None,
    scope: Option[String] = None,
    sessionCookieName: Option[String] = None,
    sessionTimeout: Option[Number] = None,
    onUnauthenticatedRequest: Option[String] = None,
    authenticationRequestExtraParams: Option[Map[String, String]] = None
  ): software.amazon.awscdk.services.elasticloadbalancingv2.CfnListenerRule.AuthenticateOidcConfigProperty =
    (new software.amazon.awscdk.services.elasticloadbalancingv2.CfnListenerRule.AuthenticateOidcConfigProperty.Builder)
      .clientId(clientId)
      .issuer(issuer)
      .authorizationEndpoint(authorizationEndpoint)
      .clientSecret(clientSecret)
      .userInfoEndpoint(userInfoEndpoint)
      .tokenEndpoint(tokenEndpoint)
      .useExistingClientSecret(useExistingClientSecret.map(Boolean.box).orNull)
      .scope(scope.orNull)
      .sessionCookieName(sessionCookieName.orNull)
      .sessionTimeout(sessionTimeout.orNull)
      .onUnauthenticatedRequest(onUnauthenticatedRequest.orNull)
      .authenticationRequestExtraParams(authenticationRequestExtraParams.map(_.asJava).orNull)
      .build()
}
