package io.burkard.cdk.services.efs

@SuppressWarnings(Array("org.wartremover.warts.DefaultArguments", "org.wartremover.warts.Null", "DisableSyntax.null"))
object AccessPointOptions {

  def apply(
    path: Option[String] = None,
    posixUser: Option[software.amazon.awscdk.services.efs.PosixUser] = None,
    createAcl: Option[software.amazon.awscdk.services.efs.Acl] = None
  ): software.amazon.awscdk.services.efs.AccessPointOptions =
    (new software.amazon.awscdk.services.efs.AccessPointOptions.Builder)
      .path(path.orNull)
      .posixUser(posixUser.orNull)
      .createAcl(createAcl.orNull)
      .build()
}
