package io.burkard.cdk.services.ecs.cfnTaskDefinition

@SuppressWarnings(Array("org.wartremover.warts.DefaultArguments", "org.wartremover.warts.Null", "DisableSyntax.null"))
object EFSVolumeConfigurationProperty {

  def apply(
    filesystemId: String,
    authorizationConfig: Option[software.amazon.awscdk.services.ecs.CfnTaskDefinition.AuthorizationConfigProperty] = None,
    transitEncryption: Option[String] = None,
    transitEncryptionPort: Option[Number] = None,
    rootDirectory: Option[String] = None
  ): software.amazon.awscdk.services.ecs.CfnTaskDefinition.EFSVolumeConfigurationProperty =
    (new software.amazon.awscdk.services.ecs.CfnTaskDefinition.EFSVolumeConfigurationProperty.Builder)
      .filesystemId(filesystemId)
      .authorizationConfig(authorizationConfig.orNull)
      .transitEncryption(transitEncryption.orNull)
      .transitEncryptionPort(transitEncryptionPort.orNull)
      .rootDirectory(rootDirectory.orNull)
      .build()
}
