package io.burkard.cdk.services.ec2.cfnLaunchTemplate

import scala.collection.JavaConverters._

@scala.annotation.nowarn("cat=deprecation")
@SuppressWarnings(Array("org.wartremover.warts.DefaultArguments", "org.wartremover.warts.Null", "DisableSyntax.null"))
object LaunchTemplateDataProperty {

  def apply(
    instanceMarketOptions: Option[software.amazon.awscdk.services.ec2.CfnLaunchTemplate.InstanceMarketOptionsProperty] = None,
    ebsOptimized: Option[Boolean] = None,
    tagSpecifications: Option[List[_]] = None,
    cpuOptions: Option[software.amazon.awscdk.services.ec2.CfnLaunchTemplate.CpuOptionsProperty] = None,
    disableApiTermination: Option[Boolean] = None,
    networkInterfaces: Option[List[_]] = None,
    capacityReservationSpecification: Option[software.amazon.awscdk.services.ec2.CfnLaunchTemplate.CapacityReservationSpecificationProperty] = None,
    monitoring: Option[software.amazon.awscdk.services.ec2.CfnLaunchTemplate.MonitoringProperty] = None,
    userData: Option[String] = None,
    securityGroupIds: Option[List[String]] = None,
    iamInstanceProfile: Option[software.amazon.awscdk.services.ec2.CfnLaunchTemplate.IamInstanceProfileProperty] = None,
    instanceType: Option[String] = None,
    creditSpecification: Option[software.amazon.awscdk.services.ec2.CfnLaunchTemplate.CreditSpecificationProperty] = None,
    elasticGpuSpecifications: Option[List[_]] = None,
    instanceRequirements: Option[software.amazon.awscdk.services.ec2.CfnLaunchTemplate.InstanceRequirementsProperty] = None,
    elasticInferenceAccelerators: Option[List[_]] = None,
    placement: Option[software.amazon.awscdk.services.ec2.CfnLaunchTemplate.PlacementProperty] = None,
    disableApiStop: Option[Boolean] = None,
    hibernationOptions: Option[software.amazon.awscdk.services.ec2.CfnLaunchTemplate.HibernationOptionsProperty] = None,
    imageId: Option[String] = None,
    enclaveOptions: Option[software.amazon.awscdk.services.ec2.CfnLaunchTemplate.EnclaveOptionsProperty] = None,
    privateDnsNameOptions: Option[software.amazon.awscdk.services.ec2.CfnLaunchTemplate.PrivateDnsNameOptionsProperty] = None,
    metadataOptions: Option[software.amazon.awscdk.services.ec2.CfnLaunchTemplate.MetadataOptionsProperty] = None,
    ramDiskId: Option[String] = None,
    securityGroups: Option[List[String]] = None,
    keyName: Option[String] = None,
    instanceInitiatedShutdownBehavior: Option[String] = None,
    kernelId: Option[String] = None,
    licenseSpecifications: Option[List[_]] = None,
    maintenanceOptions: Option[software.amazon.awscdk.services.ec2.CfnLaunchTemplate.MaintenanceOptionsProperty] = None,
    blockDeviceMappings: Option[List[_]] = None
  ): software.amazon.awscdk.services.ec2.CfnLaunchTemplate.LaunchTemplateDataProperty =
    (new software.amazon.awscdk.services.ec2.CfnLaunchTemplate.LaunchTemplateDataProperty.Builder)
      .instanceMarketOptions(instanceMarketOptions.orNull)
      .ebsOptimized(ebsOptimized.map(Boolean.box).orNull)
      .tagSpecifications(tagSpecifications.map(_.asJava).orNull)
      .cpuOptions(cpuOptions.orNull)
      .disableApiTermination(disableApiTermination.map(Boolean.box).orNull)
      .networkInterfaces(networkInterfaces.map(_.asJava).orNull)
      .capacityReservationSpecification(capacityReservationSpecification.orNull)
      .monitoring(monitoring.orNull)
      .userData(userData.orNull)
      .securityGroupIds(securityGroupIds.map(_.asJava).orNull)
      .iamInstanceProfile(iamInstanceProfile.orNull)
      .instanceType(instanceType.orNull)
      .creditSpecification(creditSpecification.orNull)
      .elasticGpuSpecifications(elasticGpuSpecifications.map(_.asJava).orNull)
      .instanceRequirements(instanceRequirements.orNull)
      .elasticInferenceAccelerators(elasticInferenceAccelerators.map(_.asJava).orNull)
      .placement(placement.orNull)
      .disableApiStop(disableApiStop.map(Boolean.box).orNull)
      .hibernationOptions(hibernationOptions.orNull)
      .imageId(imageId.orNull)
      .enclaveOptions(enclaveOptions.orNull)
      .privateDnsNameOptions(privateDnsNameOptions.orNull)
      .metadataOptions(metadataOptions.orNull)
      .ramDiskId(ramDiskId.orNull)
      .securityGroups(securityGroups.map(_.asJava).orNull)
      .keyName(keyName.orNull)
      .instanceInitiatedShutdownBehavior(instanceInitiatedShutdownBehavior.orNull)
      .kernelId(kernelId.orNull)
      .licenseSpecifications(licenseSpecifications.map(_.asJava).orNull)
      .maintenanceOptions(maintenanceOptions.orNull)
      .blockDeviceMappings(blockDeviceMappings.map(_.asJava).orNull)
      .build()
}
