package io.burkard.cdk.services.dms.cfnEndpoint

import scala.collection.JavaConverters._

@scala.annotation.nowarn("cat=deprecation")
@SuppressWarnings(Array("org.wartremover.warts.DefaultArguments", "org.wartremover.warts.Null", "DisableSyntax.null"))
object OracleSettingsProperty {

  def apply(
    readAheadBlocks: Option[Number] = None,
    numberDatatypeScale: Option[Number] = None,
    asmServer: Option[String] = None,
    oraclePathPrefix: Option[String] = None,
    directPathParallelLoad: Option[Boolean] = None,
    additionalArchivedLogDestId: Option[Number] = None,
    secretsManagerOracleAsmSecretId: Option[String] = None,
    accessAlternateDirectly: Option[Boolean] = None,
    replacePathPrefix: Option[Boolean] = None,
    secretsManagerAccessRoleArn: Option[String] = None,
    standbyDelayTime: Option[Number] = None,
    useAlternateFolderForOnline: Option[Boolean] = None,
    allowSelectNestedTables: Option[Boolean] = None,
    archivedLogsOnly: Option[Boolean] = None,
    usePathPrefix: Option[String] = None,
    charLengthSemantics: Option[String] = None,
    directPathNoLog: Option[Boolean] = None,
    secretsManagerSecretId: Option[String] = None,
    secretsManagerOracleAsmAccessRoleArn: Option[String] = None,
    enableHomogenousTablespace: Option[Boolean] = None,
    addSupplementalLogging: Option[Boolean] = None,
    readTableSpaceName: Option[Boolean] = None,
    archivedLogDestId: Option[Number] = None,
    spatialDataOptionToGeoJsonFunctionName: Option[String] = None,
    failTasksOnLobTruncation: Option[Boolean] = None,
    asmUser: Option[String] = None,
    parallelAsmReadThreads: Option[Number] = None,
    extraArchivedLogDestIds: Option[List[_ <: Number]] = None,
    securityDbEncryptionName: Option[String] = None,
    useDirectPathFullLoad: Option[Boolean] = None,
    useBFile: Option[Boolean] = None,
    securityDbEncryption: Option[String] = None,
    useLogminerReader: Option[Boolean] = None,
    retryInterval: Option[Number] = None,
    asmPassword: Option[String] = None
  ): software.amazon.awscdk.services.dms.CfnEndpoint.OracleSettingsProperty =
    (new software.amazon.awscdk.services.dms.CfnEndpoint.OracleSettingsProperty.Builder)
      .readAheadBlocks(readAheadBlocks.orNull)
      .numberDatatypeScale(numberDatatypeScale.orNull)
      .asmServer(asmServer.orNull)
      .oraclePathPrefix(oraclePathPrefix.orNull)
      .directPathParallelLoad(directPathParallelLoad.map(Boolean.box).orNull)
      .additionalArchivedLogDestId(additionalArchivedLogDestId.orNull)
      .secretsManagerOracleAsmSecretId(secretsManagerOracleAsmSecretId.orNull)
      .accessAlternateDirectly(accessAlternateDirectly.map(Boolean.box).orNull)
      .replacePathPrefix(replacePathPrefix.map(Boolean.box).orNull)
      .secretsManagerAccessRoleArn(secretsManagerAccessRoleArn.orNull)
      .standbyDelayTime(standbyDelayTime.orNull)
      .useAlternateFolderForOnline(useAlternateFolderForOnline.map(Boolean.box).orNull)
      .allowSelectNestedTables(allowSelectNestedTables.map(Boolean.box).orNull)
      .archivedLogsOnly(archivedLogsOnly.map(Boolean.box).orNull)
      .usePathPrefix(usePathPrefix.orNull)
      .charLengthSemantics(charLengthSemantics.orNull)
      .directPathNoLog(directPathNoLog.map(Boolean.box).orNull)
      .secretsManagerSecretId(secretsManagerSecretId.orNull)
      .secretsManagerOracleAsmAccessRoleArn(secretsManagerOracleAsmAccessRoleArn.orNull)
      .enableHomogenousTablespace(enableHomogenousTablespace.map(Boolean.box).orNull)
      .addSupplementalLogging(addSupplementalLogging.map(Boolean.box).orNull)
      .readTableSpaceName(readTableSpaceName.map(Boolean.box).orNull)
      .archivedLogDestId(archivedLogDestId.orNull)
      .spatialDataOptionToGeoJsonFunctionName(spatialDataOptionToGeoJsonFunctionName.orNull)
      .failTasksOnLobTruncation(failTasksOnLobTruncation.map(Boolean.box).orNull)
      .asmUser(asmUser.orNull)
      .parallelAsmReadThreads(parallelAsmReadThreads.orNull)
      .extraArchivedLogDestIds(extraArchivedLogDestIds.map(_.asJava).orNull)
      .securityDbEncryptionName(securityDbEncryptionName.orNull)
      .useDirectPathFullLoad(useDirectPathFullLoad.map(Boolean.box).orNull)
      .useBFile(useBFile.map(Boolean.box).orNull)
      .securityDbEncryption(securityDbEncryption.orNull)
      .useLogminerReader(useLogminerReader.map(Boolean.box).orNull)
      .retryInterval(retryInterval.orNull)
      .asmPassword(asmPassword.orNull)
      .build()
}
