package io.burkard.cdk.services.codepipeline

import scala.collection.JavaConverters._

@scala.annotation.nowarn("cat=deprecation")
@SuppressWarnings(Array("org.wartremover.warts.DefaultArguments", "org.wartremover.warts.Null", "DisableSyntax.null"))
object StageOptions {

  def apply(
    transitionDisabledReason: Option[String] = None,
    placement: Option[software.amazon.awscdk.services.codepipeline.StagePlacement] = None,
    transitionToEnabled: Option[Boolean] = None,
    stageName: Option[String] = None,
    actions: Option[List[_ <: software.amazon.awscdk.services.codepipeline.IAction]] = None
  ): software.amazon.awscdk.services.codepipeline.StageOptions =
    (new software.amazon.awscdk.services.codepipeline.StageOptions.Builder)
      .transitionDisabledReason(transitionDisabledReason.orNull)
      .placement(placement.orNull)
      .transitionToEnabled(transitionToEnabled.map(Boolean.box).orNull)
      .stageName(stageName.orNull)
      .actions(actions.map(_.asJava).orNull)
      .build()
}
