package io.burkard.cdk.services.cloudwatch

@SuppressWarnings(Array("org.wartremover.warts.DefaultArguments", "org.wartremover.warts.Null", "DisableSyntax.null"))
object CustomWidgetProps {

  def apply(
    title: String,
    functionArn: String,
    params: Option[AnyRef] = None,
    height: Option[Number] = None,
    updateOnRefresh: Option[Boolean] = None,
    updateOnResize: Option[Boolean] = None,
    width: Option[Number] = None,
    updateOnTimeRangeChange: Option[Boolean] = None
  ): software.amazon.awscdk.services.cloudwatch.CustomWidgetProps =
    (new software.amazon.awscdk.services.cloudwatch.CustomWidgetProps.Builder)
      .title(title)
      .functionArn(functionArn)
      .params(params.orNull)
      .height(height.orNull)
      .updateOnRefresh(updateOnRefresh.map(Boolean.box).orNull)
      .updateOnResize(updateOnResize.map(Boolean.box).orNull)
      .width(width.orNull)
      .updateOnTimeRangeChange(updateOnTimeRangeChange.map(Boolean.box).orNull)
      .build()
}
