package io.burkard.cdk.services.cloudwatch

sealed abstract class AlarmStatusWidgetSortBy(val underlying: software.amazon.awscdk.services.cloudwatch.AlarmStatusWidgetSortBy)
  extends Product
    with Serializable

object AlarmStatusWidgetSortBy {
  implicit def toAws(value: AlarmStatusWidgetSortBy): software.amazon.awscdk.services.cloudwatch.AlarmStatusWidgetSortBy =
    Option(value).map(_.underlying).orNull

  case object Default
    extends AlarmStatusWidgetSortBy(software.amazon.awscdk.services.cloudwatch.AlarmStatusWidgetSortBy.DEFAULT)

  case object StateUpdatedTimestamp
    extends AlarmStatusWidgetSortBy(software.amazon.awscdk.services.cloudwatch.AlarmStatusWidgetSortBy.STATE_UPDATED_TIMESTAMP)

  case object Timestamp
    extends AlarmStatusWidgetSortBy(software.amazon.awscdk.services.cloudwatch.AlarmStatusWidgetSortBy.TIMESTAMP)
}
