package io.burkard.cdk.services.cloudfront

@SuppressWarnings(Array("org.wartremover.warts.DefaultArguments", "org.wartremover.warts.Null", "DisableSyntax.null"))
object ErrorResponse {

  def apply(
    httpStatus: Number,
    ttl: Option[software.amazon.awscdk.Duration] = None,
    responsePagePath: Option[String] = None,
    responseHttpStatus: Option[Number] = None
  ): software.amazon.awscdk.services.cloudfront.ErrorResponse =
    (new software.amazon.awscdk.services.cloudfront.ErrorResponse.Builder)
      .httpStatus(httpStatus)
      .ttl(ttl.orNull)
      .responsePagePath(responsePagePath.orNull)
      .responseHttpStatus(responseHttpStatus.orNull)
      .build()
}
