package io.burkard.cdk.services.autoscaling

@SuppressWarnings(Array("org.wartremover.warts.DefaultArguments", "org.wartremover.warts.Null", "DisableSyntax.null"))
object WarmPoolOptions {

  def apply(
    maxGroupPreparedCapacity: Option[Number] = None,
    poolState: Option[software.amazon.awscdk.services.autoscaling.PoolState] = None,
    reuseOnScaleIn: Option[Boolean] = None,
    minSize: Option[Number] = None
  ): software.amazon.awscdk.services.autoscaling.WarmPoolOptions =
    (new software.amazon.awscdk.services.autoscaling.WarmPoolOptions.Builder)
      .maxGroupPreparedCapacity(maxGroupPreparedCapacity.orNull)
      .poolState(poolState.orNull)
      .reuseOnScaleIn(reuseOnScaleIn.map(Boolean.box).orNull)
      .minSize(minSize.orNull)
      .build()
}
