package io.burkard.cdk.services.autoscaling

@SuppressWarnings(Array("org.wartremover.warts.DefaultArguments", "org.wartremover.warts.Null", "DisableSyntax.null"))
object BaseTargetTrackingProps {

  def apply(
    cooldown: Option[software.amazon.awscdk.Duration] = None,
    disableScaleIn: Option[Boolean] = None,
    estimatedInstanceWarmup: Option[software.amazon.awscdk.Duration] = None
  ): software.amazon.awscdk.services.autoscaling.BaseTargetTrackingProps =
    (new software.amazon.awscdk.services.autoscaling.BaseTargetTrackingProps.Builder)
      .cooldown(cooldown.orNull)
      .disableScaleIn(disableScaleIn.map(Boolean.box).orNull)
      .estimatedInstanceWarmup(estimatedInstanceWarmup.orNull)
      .build()
}
