package io.burkard.cdk.services.applicationinsights.cfnApplication

import scala.collection.JavaConverters._

@scala.annotation.nowarn("cat=deprecation")
@SuppressWarnings(Array("org.wartremover.warts.DefaultArguments", "org.wartremover.warts.Null", "DisableSyntax.null"))
object WindowsEventProperty {

  def apply(
    logGroupName: String,
    eventName: String,
    eventLevels: List[String],
    patternSet: Option[String] = None
  ): software.amazon.awscdk.services.applicationinsights.CfnApplication.WindowsEventProperty =
    (new software.amazon.awscdk.services.applicationinsights.CfnApplication.WindowsEventProperty.Builder)
      .logGroupName(logGroupName)
      .eventName(eventName)
      .eventLevels(eventLevels.asJava)
      .patternSet(patternSet.orNull)
      .build()
}
