package io.burkard.cdk.services.apigateway

import scala.collection.JavaConverters._

@scala.annotation.nowarn("cat=deprecation")
@SuppressWarnings(Array("org.wartremover.warts.DefaultArguments", "org.wartremover.warts.Null", "DisableSyntax.null"))
object CfnRestApiProps {

  def apply(
    body: Option[AnyRef] = None,
    name: Option[String] = None,
    apiKeySourceType: Option[String] = None,
    description: Option[String] = None,
    tags: Option[List[_ <: software.amazon.awscdk.CfnTag]] = None,
    binaryMediaTypes: Option[List[String]] = None,
    failOnWarnings: Option[Boolean] = None,
    cloneFrom: Option[String] = None,
    disableExecuteApiEndpoint: Option[Boolean] = None,
    endpointConfiguration: Option[software.amazon.awscdk.services.apigateway.CfnRestApi.EndpointConfigurationProperty] = None,
    mode: Option[String] = None,
    bodyS3Location: Option[software.amazon.awscdk.services.apigateway.CfnRestApi.S3LocationProperty] = None,
    parameters: Option[Map[String, String]] = None,
    policy: Option[AnyRef] = None,
    minimumCompressionSize: Option[Number] = None
  ): software.amazon.awscdk.services.apigateway.CfnRestApiProps =
    (new software.amazon.awscdk.services.apigateway.CfnRestApiProps.Builder)
      .body(body.orNull)
      .name(name.orNull)
      .apiKeySourceType(apiKeySourceType.orNull)
      .description(description.orNull)
      .tags(tags.map(_.asJava).orNull)
      .binaryMediaTypes(binaryMediaTypes.map(_.asJava).orNull)
      .failOnWarnings(failOnWarnings.map(Boolean.box).orNull)
      .cloneFrom(cloneFrom.orNull)
      .disableExecuteApiEndpoint(disableExecuteApiEndpoint.map(Boolean.box).orNull)
      .endpointConfiguration(endpointConfiguration.orNull)
      .mode(mode.orNull)
      .bodyS3Location(bodyS3Location.orNull)
      .parameters(parameters.map(_.asJava).orNull)
      .policy(policy.orNull)
      .minimumCompressionSize(minimumCompressionSize.orNull)
      .build()
}
