package io.burkard.cdk.triggers

import scala.collection.JavaConverters._

@scala.annotation.nowarn("cat=deprecation")
@SuppressWarnings(Array("org.wartremover.warts.DefaultArguments", "org.wartremover.warts.Null", "DisableSyntax.null"))
object TriggerOptions {

  def apply(
    executeAfter: Option[List[_ <: software.constructs.Construct]] = None,
    executeBefore: Option[List[_ <: software.constructs.Construct]] = None,
    executeOnHandlerChange: Option[Boolean] = None
  ): software.amazon.awscdk.triggers.TriggerOptions =
    (new software.amazon.awscdk.triggers.TriggerOptions.Builder)
      .executeAfter(executeAfter.map(_.asJava).orNull)
      .executeBefore(executeBefore.map(_.asJava).orNull)
      .executeOnHandlerChange(executeOnHandlerChange.map(Boolean.box).orNull)
      .build()
}
