package io.burkard.cdk.triggers

sealed abstract class TriggerInvalidation(val underlying: software.amazon.awscdk.triggers.TriggerInvalidation)
  extends Product
    with Serializable

object TriggerInvalidation {
  implicit def toAws(value: TriggerInvalidation): software.amazon.awscdk.triggers.TriggerInvalidation =
    Option(value).map(_.underlying).orNull

  case object HandlerChange
    extends TriggerInvalidation(software.amazon.awscdk.triggers.TriggerInvalidation.HANDLER_CHANGE)
}
