package io.burkard.cdk.services.synthetics.cfnCanary

import scala.collection.JavaConverters._

@scala.annotation.nowarn("cat=deprecation")
@SuppressWarnings(Array("org.wartremover.warts.DefaultArguments", "org.wartremover.warts.Null", "DisableSyntax.null"))
object RunConfigProperty {

  def apply(
    environmentVariables: Option[Map[String, String]] = None,
    timeoutInSeconds: Option[Number] = None,
    activeTracing: Option[Boolean] = None,
    memoryInMb: Option[Number] = None
  ): software.amazon.awscdk.services.synthetics.CfnCanary.RunConfigProperty =
    (new software.amazon.awscdk.services.synthetics.CfnCanary.RunConfigProperty.Builder)
      .environmentVariables(environmentVariables.map(_.asJava).orNull)
      .timeoutInSeconds(timeoutInSeconds.orNull)
      .activeTracing(activeTracing.map(Boolean.box).orNull)
      .memoryInMb(memoryInMb.orNull)
      .build()
}
