package io.burkard.cdk.services.stepfunctions

@SuppressWarnings(Array("org.wartremover.warts.DefaultArguments", "org.wartremover.warts.Null", "DisableSyntax.null"))
object Choice {

  def apply(
    internalResourceId: String,
    comment: Option[String] = None,
    inputPath: Option[String] = None,
    outputPath: Option[String] = None
  )(implicit stackCtx: software.amazon.awscdk.Stack): software.amazon.awscdk.services.stepfunctions.Choice =
    software.amazon.awscdk.services.stepfunctions.Choice.Builder
      .create(stackCtx, internalResourceId)
      .comment(comment.orNull)
      .inputPath(inputPath.orNull)
      .outputPath(outputPath.orNull)
      .build()
}
