package io.burkard.cdk.services.sns.subscriptions

import scala.collection.JavaConverters._

@scala.annotation.nowarn("cat=deprecation")
@SuppressWarnings(Array("org.wartremover.warts.DefaultArguments", "org.wartremover.warts.Null", "DisableSyntax.null"))
object UrlSubscriptionProps {

  def apply(
    protocol: Option[software.amazon.awscdk.services.sns.SubscriptionProtocol] = None,
    rawMessageDelivery: Option[Boolean] = None,
    filterPolicy: Option[Map[String, _ <: software.amazon.awscdk.services.sns.SubscriptionFilter]] = None,
    deadLetterQueue: Option[software.amazon.awscdk.services.sqs.IQueue] = None
  ): software.amazon.awscdk.services.sns.subscriptions.UrlSubscriptionProps =
    (new software.amazon.awscdk.services.sns.subscriptions.UrlSubscriptionProps.Builder)
      .protocol(protocol.orNull)
      .rawMessageDelivery(rawMessageDelivery.map(Boolean.box).orNull)
      .filterPolicy(filterPolicy.map(_.asJava).orNull)
      .deadLetterQueue(deadLetterQueue.orNull)
      .build()
}
