package io.burkard.cdk.services.ses.actions

@SuppressWarnings(Array("org.wartremover.warts.DefaultArguments", "org.wartremover.warts.Null", "DisableSyntax.null"))
object S3 {

  def apply(
    bucket: software.amazon.awscdk.services.s3.IBucket,
    topic: Option[software.amazon.awscdk.services.sns.ITopic] = None,
    objectKeyPrefix: Option[String] = None,
    kmsKey: Option[software.amazon.awscdk.services.kms.IKey] = None
  ): software.amazon.awscdk.services.ses.actions.S3 =
    software.amazon.awscdk.services.ses.actions.S3.Builder
      .create()
      .bucket(bucket)
      .topic(topic.orNull)
      .objectKeyPrefix(objectKeyPrefix.orNull)
      .kmsKey(kmsKey.orNull)
      .build()
}
