package io.burkard.cdk.services.servicecatalog

@SuppressWarnings(Array("org.wartremover.warts.DefaultArguments", "org.wartremover.warts.Null", "DisableSyntax.null"))
object CfnTagOption {

  def apply(
    internalResourceId: String,
    value: String,
    key: String,
    active: Option[Boolean] = None
  )(implicit stackCtx: software.amazon.awscdk.Stack): software.amazon.awscdk.services.servicecatalog.CfnTagOption =
    software.amazon.awscdk.services.servicecatalog.CfnTagOption.Builder
      .create(stackCtx, internalResourceId)
      .value(value)
      .key(key)
      .active(active.map(Boolean.box).orNull)
      .build()
}
