package io.burkard.cdk.services.sagemaker.cfnModelQualityJobDefinition

@SuppressWarnings(Array("org.wartremover.warts.DefaultArguments", "org.wartremover.warts.Null", "DisableSyntax.null"))
object ClusterConfigProperty {

  def apply(
    instanceCount: Number,
    volumeSizeInGb: Number,
    instanceType: String,
    volumeKmsKeyId: Option[String] = None
  ): software.amazon.awscdk.services.sagemaker.CfnModelQualityJobDefinition.ClusterConfigProperty =
    (new software.amazon.awscdk.services.sagemaker.CfnModelQualityJobDefinition.ClusterConfigProperty.Builder)
      .instanceCount(instanceCount)
      .volumeSizeInGb(volumeSizeInGb)
      .instanceType(instanceType)
      .volumeKmsKeyId(volumeKmsKeyId.orNull)
      .build()
}
