package io.burkard.cdk.services.sagemaker.cfnEndpointConfig

@SuppressWarnings(Array("org.wartremover.warts.DefaultArguments", "org.wartremover.warts.Null", "DisableSyntax.null"))
object AsyncInferenceOutputConfigProperty {

  def apply(
    s3OutputPath: String,
    notificationConfig: Option[software.amazon.awscdk.services.sagemaker.CfnEndpointConfig.AsyncInferenceNotificationConfigProperty] = None,
    kmsKeyId: Option[String] = None
  ): software.amazon.awscdk.services.sagemaker.CfnEndpointConfig.AsyncInferenceOutputConfigProperty =
    (new software.amazon.awscdk.services.sagemaker.CfnEndpointConfig.AsyncInferenceOutputConfigProperty.Builder)
      .s3OutputPath(s3OutputPath)
      .notificationConfig(notificationConfig.orNull)
      .kmsKeyId(kmsKeyId.orNull)
      .build()
}
