package io.burkard.cdk.services.sagemaker.cfnDataQualityJobDefinition

@SuppressWarnings(Array("org.wartremover.warts.DefaultArguments", "org.wartremover.warts.Null", "DisableSyntax.null"))
object ClusterConfigProperty {

  def apply(
    instanceCount: Number,
    volumeSizeInGb: Number,
    instanceType: String,
    volumeKmsKeyId: Option[String] = None
  ): software.amazon.awscdk.services.sagemaker.CfnDataQualityJobDefinition.ClusterConfigProperty =
    (new software.amazon.awscdk.services.sagemaker.CfnDataQualityJobDefinition.ClusterConfigProperty.Builder)
      .instanceCount(instanceCount)
      .volumeSizeInGb(volumeSizeInGb)
      .instanceType(instanceType)
      .volumeKmsKeyId(volumeKmsKeyId.orNull)
      .build()
}
