package io.burkard.cdk.services.s3outposts

@SuppressWarnings(Array("org.wartremover.warts.DefaultArguments", "org.wartremover.warts.Null", "DisableSyntax.null"))
object CfnAccessPoint {

  def apply(
    internalResourceId: String,
    name: String,
    bucket: String,
    vpcConfiguration: software.amazon.awscdk.services.s3outposts.CfnAccessPoint.VpcConfigurationProperty,
    policy: Option[AnyRef] = None
  )(implicit stackCtx: software.amazon.awscdk.Stack): software.amazon.awscdk.services.s3outposts.CfnAccessPoint =
    software.amazon.awscdk.services.s3outposts.CfnAccessPoint.Builder
      .create(stackCtx, internalResourceId)
      .name(name)
      .bucket(bucket)
      .vpcConfiguration(vpcConfiguration)
      .policy(policy.orNull)
      .build()
}
