package io.burkard.cdk.services.route53

@SuppressWarnings(Array("org.wartremover.warts.DefaultArguments", "org.wartremover.warts.Null", "DisableSyntax.null"))
object HostedZoneProviderProps {

  def apply(
    domainName: String,
    privateZone: Option[Boolean] = None,
    vpcId: Option[String] = None
  ): software.amazon.awscdk.services.route53.HostedZoneProviderProps =
    (new software.amazon.awscdk.services.route53.HostedZoneProviderProps.Builder)
      .domainName(domainName)
      .privateZone(privateZone.map(Boolean.box).orNull)
      .vpcId(vpcId.orNull)
      .build()
}
