package io.burkard.cdk.services.robomaker

import scala.collection.JavaConverters._

@scala.annotation.nowarn("cat=deprecation")
@SuppressWarnings(Array("org.wartremover.warts.DefaultArguments", "org.wartremover.warts.Null", "DisableSyntax.null"))
object CfnRobotApplicationProps {

  def apply(
    robotSoftwareSuite: software.amazon.awscdk.services.robomaker.CfnRobotApplication.RobotSoftwareSuiteProperty,
    name: Option[String] = None,
    tags: Option[Map[String, String]] = None,
    environment: Option[String] = None,
    currentRevisionId: Option[String] = None,
    sources: Option[List[_]] = None
  ): software.amazon.awscdk.services.robomaker.CfnRobotApplicationProps =
    (new software.amazon.awscdk.services.robomaker.CfnRobotApplicationProps.Builder)
      .robotSoftwareSuite(robotSoftwareSuite)
      .name(name.orNull)
      .tags(tags.map(_.asJava).orNull)
      .environment(environment.orNull)
      .currentRevisionId(currentRevisionId.orNull)
      .sources(sources.map(_.asJava).orNull)
      .build()
}
