package io.burkard.cdk.services.refactorspaces

import scala.collection.JavaConverters._

@scala.annotation.nowarn("cat=deprecation")
@SuppressWarnings(Array("org.wartremover.warts.DefaultArguments", "org.wartremover.warts.Null", "DisableSyntax.null"))
object CfnApplicationProps {

  def apply(
    name: Option[String] = None,
    vpcId: Option[String] = None,
    tags: Option[List[_ <: software.amazon.awscdk.CfnTag]] = None,
    apiGatewayProxy: Option[software.amazon.awscdk.services.refactorspaces.CfnApplication.ApiGatewayProxyInputProperty] = None,
    proxyType: Option[String] = None,
    environmentIdentifier: Option[String] = None
  ): software.amazon.awscdk.services.refactorspaces.CfnApplicationProps =
    (new software.amazon.awscdk.services.refactorspaces.CfnApplicationProps.Builder)
      .name(name.orNull)
      .vpcId(vpcId.orNull)
      .tags(tags.map(_.asJava).orNull)
      .apiGatewayProxy(apiGatewayProxy.orNull)
      .proxyType(proxyType.orNull)
      .environmentIdentifier(environmentIdentifier.orNull)
      .build()
}
