package io.burkard.cdk.services.rds

import scala.collection.JavaConverters._

@scala.annotation.nowarn("cat=deprecation")
@SuppressWarnings(Array("org.wartremover.warts.DefaultArguments", "org.wartremover.warts.Null", "DisableSyntax.null"))
object DatabaseProxyProps {

  def apply(
    proxyTarget: software.amazon.awscdk.services.rds.ProxyTarget,
    iamAuth: Option[Boolean] = None,
    maxConnectionsPercent: Option[Number] = None,
    secrets: Option[List[_ <: software.amazon.awscdk.services.secretsmanager.ISecret]] = None,
    role: Option[software.amazon.awscdk.services.iam.IRole] = None,
    maxIdleConnectionsPercent: Option[Number] = None,
    sessionPinningFilters: Option[List[_ <: software.amazon.awscdk.services.rds.SessionPinningFilter]] = None,
    vpcSubnets: Option[software.amazon.awscdk.services.ec2.SubnetSelection] = None,
    initQuery: Option[String] = None,
    debugLogging: Option[Boolean] = None,
    securityGroups: Option[List[_ <: software.amazon.awscdk.services.ec2.ISecurityGroup]] = None,
    borrowTimeout: Option[software.amazon.awscdk.Duration] = None,
    vpc: Option[software.amazon.awscdk.services.ec2.IVpc] = None,
    requireTls: Option[Boolean] = None,
    dbProxyName: Option[String] = None,
    idleClientTimeout: Option[software.amazon.awscdk.Duration] = None
  ): software.amazon.awscdk.services.rds.DatabaseProxyProps =
    (new software.amazon.awscdk.services.rds.DatabaseProxyProps.Builder)
      .proxyTarget(proxyTarget)
      .iamAuth(iamAuth.map(Boolean.box).orNull)
      .maxConnectionsPercent(maxConnectionsPercent.orNull)
      .secrets(secrets.map(_.asJava).orNull)
      .role(role.orNull)
      .maxIdleConnectionsPercent(maxIdleConnectionsPercent.orNull)
      .sessionPinningFilters(sessionPinningFilters.map(_.asJava).orNull)
      .vpcSubnets(vpcSubnets.orNull)
      .initQuery(initQuery.orNull)
      .debugLogging(debugLogging.map(Boolean.box).orNull)
      .securityGroups(securityGroups.map(_.asJava).orNull)
      .borrowTimeout(borrowTimeout.orNull)
      .vpc(vpc.orNull)
      .requireTls(requireTls.map(Boolean.box).orNull)
      .dbProxyName(dbProxyName.orNull)
      .idleClientTimeout(idleClientTimeout.orNull)
      .build()
}
