package io.burkard.cdk.services.mediapackage.cfnPackagingConfiguration

import scala.collection.JavaConverters._

@scala.annotation.nowarn("cat=deprecation")
@SuppressWarnings(Array("org.wartremover.warts.DefaultArguments", "org.wartremover.warts.Null", "DisableSyntax.null"))
object HlsPackageProperty {

  def apply(
    hlsManifests: List[_],
    encryption: Option[software.amazon.awscdk.services.mediapackage.CfnPackagingConfiguration.HlsEncryptionProperty] = None,
    segmentDurationSeconds: Option[Number] = None,
    useAudioRenditionGroup: Option[Boolean] = None
  ): software.amazon.awscdk.services.mediapackage.CfnPackagingConfiguration.HlsPackageProperty =
    (new software.amazon.awscdk.services.mediapackage.CfnPackagingConfiguration.HlsPackageProperty.Builder)
      .hlsManifests(hlsManifests.asJava)
      .encryption(encryption.orNull)
      .segmentDurationSeconds(segmentDurationSeconds.orNull)
      .useAudioRenditionGroup(useAudioRenditionGroup.map(Boolean.box).orNull)
      .build()
}
