package io.burkard.cdk.services.mediapackage.cfnOriginEndpoint

@SuppressWarnings(Array("org.wartremover.warts.DefaultArguments", "org.wartremover.warts.Null", "DisableSyntax.null"))
object MssPackageProperty {

  def apply(
    encryption: Option[software.amazon.awscdk.services.mediapackage.CfnOriginEndpoint.MssEncryptionProperty] = None,
    streamSelection: Option[software.amazon.awscdk.services.mediapackage.CfnOriginEndpoint.StreamSelectionProperty] = None,
    segmentDurationSeconds: Option[Number] = None,
    manifestWindowSeconds: Option[Number] = None
  ): software.amazon.awscdk.services.mediapackage.CfnOriginEndpoint.MssPackageProperty =
    (new software.amazon.awscdk.services.mediapackage.CfnOriginEndpoint.MssPackageProperty.Builder)
      .encryption(encryption.orNull)
      .streamSelection(streamSelection.orNull)
      .segmentDurationSeconds(segmentDurationSeconds.orNull)
      .manifestWindowSeconds(manifestWindowSeconds.orNull)
      .build()
}
