package io.burkard.cdk.services.lightsail

import scala.collection.JavaConverters._

@scala.annotation.nowarn("cat=deprecation")
@SuppressWarnings(Array("org.wartremover.warts.DefaultArguments", "org.wartremover.warts.Null", "DisableSyntax.null"))
object CfnLoadBalancerTlsCertificateProps {

  def apply(
    certificateDomainName: String,
    certificateName: String,
    loadBalancerName: String,
    isAttached: Option[Boolean] = None,
    certificateAlternativeNames: Option[List[String]] = None
  ): software.amazon.awscdk.services.lightsail.CfnLoadBalancerTlsCertificateProps =
    (new software.amazon.awscdk.services.lightsail.CfnLoadBalancerTlsCertificateProps.Builder)
      .certificateDomainName(certificateDomainName)
      .certificateName(certificateName)
      .loadBalancerName(loadBalancerName)
      .isAttached(isAttached.map(Boolean.box).orNull)
      .certificateAlternativeNames(certificateAlternativeNames.map(_.asJava).orNull)
      .build()
}
