package io.burkard.cdk.services.lex.cfnBot

import scala.collection.JavaConverters._

@scala.annotation.nowarn("cat=deprecation")
@SuppressWarnings(Array("org.wartremover.warts.DefaultArguments", "org.wartremover.warts.Null", "DisableSyntax.null"))
object ImageResponseCardProperty {

  def apply(
    title: String,
    buttons: Option[List[_]] = None,
    imageUrl: Option[String] = None,
    subtitle: Option[String] = None
  ): software.amazon.awscdk.services.lex.CfnBot.ImageResponseCardProperty =
    (new software.amazon.awscdk.services.lex.CfnBot.ImageResponseCardProperty.Builder)
      .title(title)
      .buttons(buttons.map(_.asJava).orNull)
      .imageUrl(imageUrl.orNull)
      .subtitle(subtitle.orNull)
      .build()
}
