package io.burkard.cdk.services.lambda.eventsources

@SuppressWarnings(Array("org.wartremover.warts.DefaultArguments", "org.wartremover.warts.Null", "DisableSyntax.null"))
object SqsEventSourceProps {

  def apply(
    enabled: Option[Boolean] = None,
    batchSize: Option[Number] = None,
    reportBatchItemFailures: Option[Boolean] = None,
    maxBatchingWindow: Option[software.amazon.awscdk.Duration] = None
  ): software.amazon.awscdk.services.lambda.eventsources.SqsEventSourceProps =
    (new software.amazon.awscdk.services.lambda.eventsources.SqsEventSourceProps.Builder)
      .enabled(enabled.map(Boolean.box).orNull)
      .batchSize(batchSize.orNull)
      .reportBatchItemFailures(reportBatchItemFailures.map(Boolean.box).orNull)
      .maxBatchingWindow(maxBatchingWindow.orNull)
      .build()
}
