package io.burkard.cdk.services.lambda.eventsources

@SuppressWarnings(Array("org.wartremover.warts.DefaultArguments", "org.wartremover.warts.Null", "DisableSyntax.null"))
object SqsEventSource {

  def apply(
    queue: software.amazon.awscdk.services.sqs.IQueue,
    enabled: Option[Boolean] = None,
    batchSize: Option[Number] = None,
    reportBatchItemFailures: Option[Boolean] = None,
    maxBatchingWindow: Option[software.amazon.awscdk.Duration] = None
  ): software.amazon.awscdk.services.lambda.eventsources.SqsEventSource =
    software.amazon.awscdk.services.lambda.eventsources.SqsEventSource.Builder
      .create(queue)
      .enabled(enabled.map(Boolean.box).orNull)
      .batchSize(batchSize.orNull)
      .reportBatchItemFailures(reportBatchItemFailures.map(Boolean.box).orNull)
      .maxBatchingWindow(maxBatchingWindow.orNull)
      .build()
}
