package io.burkard.cdk.services.iotevents

import scala.collection.JavaConverters._

@scala.annotation.nowarn("cat=deprecation")
@SuppressWarnings(Array("org.wartremover.warts.DefaultArguments", "org.wartremover.warts.Null", "DisableSyntax.null"))
object CfnAlarmModel {

  def apply(
    internalResourceId: String,
    roleArn: String,
    alarmRule: software.amazon.awscdk.services.iotevents.CfnAlarmModel.AlarmRuleProperty,
    alarmModelName: Option[String] = None,
    alarmModelDescription: Option[String] = None,
    tags: Option[List[_ <: software.amazon.awscdk.CfnTag]] = None,
    alarmCapabilities: Option[software.amazon.awscdk.services.iotevents.CfnAlarmModel.AlarmCapabilitiesProperty] = None,
    key: Option[String] = None,
    severity: Option[Number] = None,
    alarmEventActions: Option[software.amazon.awscdk.services.iotevents.CfnAlarmModel.AlarmEventActionsProperty] = None
  )(implicit stackCtx: software.amazon.awscdk.Stack): software.amazon.awscdk.services.iotevents.CfnAlarmModel =
    software.amazon.awscdk.services.iotevents.CfnAlarmModel.Builder
      .create(stackCtx, internalResourceId)
      .roleArn(roleArn)
      .alarmRule(alarmRule)
      .alarmModelName(alarmModelName.orNull)
      .alarmModelDescription(alarmModelDescription.orNull)
      .tags(tags.map(_.asJava).orNull)
      .alarmCapabilities(alarmCapabilities.orNull)
      .key(key.orNull)
      .severity(severity.orNull)
      .alarmEventActions(alarmEventActions.orNull)
      .build()
}
