package io.burkard.cdk.services.iot

import scala.collection.JavaConverters._

@scala.annotation.nowarn("cat=deprecation")
@SuppressWarnings(Array("org.wartremover.warts.DefaultArguments", "org.wartremover.warts.Null", "DisableSyntax.null"))
object CfnTopicRule {

  def apply(
    internalResourceId: String,
    topicRulePayload: software.amazon.awscdk.services.iot.CfnTopicRule.TopicRulePayloadProperty,
    tags: Option[List[_ <: software.amazon.awscdk.CfnTag]] = None,
    ruleName: Option[String] = None
  )(implicit stackCtx: software.amazon.awscdk.Stack): software.amazon.awscdk.services.iot.CfnTopicRule =
    software.amazon.awscdk.services.iot.CfnTopicRule.Builder
      .create(stackCtx, internalResourceId)
      .topicRulePayload(topicRulePayload)
      .tags(tags.map(_.asJava).orNull)
      .ruleName(ruleName.orNull)
      .build()
}
