package io.burkard.cdk.services.iam

@SuppressWarnings(Array("org.wartremover.warts.DefaultArguments", "org.wartremover.warts.Null", "DisableSyntax.null"))
object AccessKey {

  def apply(
    internalResourceId: String,
    user: software.amazon.awscdk.services.iam.IUser,
    status: Option[software.amazon.awscdk.services.iam.AccessKeyStatus] = None,
    serial: Option[Number] = None
  )(implicit stackCtx: software.amazon.awscdk.Stack): software.amazon.awscdk.services.iam.AccessKey =
    software.amazon.awscdk.services.iam.AccessKey.Builder
      .create(stackCtx, internalResourceId)
      .user(user)
      .status(status.orNull)
      .serial(serial.orNull)
      .build()
}
