package io.burkard.cdk.services.fsx

import scala.collection.JavaConverters._

@scala.annotation.nowarn("cat=deprecation")
@SuppressWarnings(Array("org.wartremover.warts.DefaultArguments", "org.wartremover.warts.Null", "DisableSyntax.null"))
object CfnVolumeProps {

  def apply(
    name: String,
    ontapConfiguration: Option[software.amazon.awscdk.services.fsx.CfnVolume.OntapConfigurationProperty] = None,
    openZfsConfiguration: Option[software.amazon.awscdk.services.fsx.CfnVolume.OpenZFSConfigurationProperty] = None,
    tags: Option[List[_ <: software.amazon.awscdk.CfnTag]] = None,
    backupId: Option[String] = None,
    volumeType: Option[String] = None
  ): software.amazon.awscdk.services.fsx.CfnVolumeProps =
    (new software.amazon.awscdk.services.fsx.CfnVolumeProps.Builder)
      .name(name)
      .ontapConfiguration(ontapConfiguration.orNull)
      .openZfsConfiguration(openZfsConfiguration.orNull)
      .tags(tags.map(_.asJava).orNull)
      .backupId(backupId.orNull)
      .volumeType(volumeType.orNull)
      .build()
}
