package io.burkard.cdk.services.evidently

import scala.collection.JavaConverters._

@scala.annotation.nowarn("cat=deprecation")
@SuppressWarnings(Array("org.wartremover.warts.DefaultArguments", "org.wartremover.warts.Null", "DisableSyntax.null"))
object CfnFeatureProps {

  def apply(
    name: String,
    project: String,
    variations: List[_],
    entityOverrides: Option[List[_]] = None,
    description: Option[String] = None,
    tags: Option[List[_ <: software.amazon.awscdk.CfnTag]] = None,
    defaultVariation: Option[String] = None,
    evaluationStrategy: Option[String] = None
  ): software.amazon.awscdk.services.evidently.CfnFeatureProps =
    (new software.amazon.awscdk.services.evidently.CfnFeatureProps.Builder)
      .name(name)
      .project(project)
      .variations(variations.asJava)
      .entityOverrides(entityOverrides.map(_.asJava).orNull)
      .description(description.orNull)
      .tags(tags.map(_.asJava).orNull)
      .defaultVariation(defaultVariation.orNull)
      .evaluationStrategy(evaluationStrategy.orNull)
      .build()
}
