package io.burkard.cdk.services.events.targets

@SuppressWarnings(Array("org.wartremover.warts.DefaultArguments", "org.wartremover.warts.Null", "DisableSyntax.null"))
object CloudWatchLogGroup {

  def apply(
    logGroup: software.amazon.awscdk.services.logs.ILogGroup,
    event: Option[software.amazon.awscdk.services.events.RuleTargetInput] = None,
    deadLetterQueue: Option[software.amazon.awscdk.services.sqs.IQueue] = None,
    maxEventAge: Option[software.amazon.awscdk.Duration] = None,
    retryAttempts: Option[Number] = None
  ): software.amazon.awscdk.services.events.targets.CloudWatchLogGroup =
    software.amazon.awscdk.services.events.targets.CloudWatchLogGroup.Builder
      .create(logGroup)
      .event(event.orNull)
      .deadLetterQueue(deadLetterQueue.orNull)
      .maxEventAge(maxEventAge.orNull)
      .retryAttempts(retryAttempts.orNull)
      .build()
}
