package io.burkard.cdk.services.events.cfnConnection

@SuppressWarnings(Array("org.wartremover.warts.DefaultArguments", "org.wartremover.warts.Null", "DisableSyntax.null"))
object OAuthParametersProperty {

  def apply(
    httpMethod: String,
    clientParameters: software.amazon.awscdk.services.events.CfnConnection.ClientParametersProperty,
    authorizationEndpoint: String,
    oAuthHttpParameters: Option[software.amazon.awscdk.services.events.CfnConnection.ConnectionHttpParametersProperty] = None
  ): software.amazon.awscdk.services.events.CfnConnection.OAuthParametersProperty =
    (new software.amazon.awscdk.services.events.CfnConnection.OAuthParametersProperty.Builder)
      .httpMethod(httpMethod)
      .clientParameters(clientParameters)
      .authorizationEndpoint(authorizationEndpoint)
      .oAuthHttpParameters(oAuthHttpParameters.orNull)
      .build()
}
