package io.burkard.cdk.services.events.cfnConnection

@SuppressWarnings(Array("org.wartremover.warts.DefaultArguments", "org.wartremover.warts.Null", "DisableSyntax.null"))
object AuthParametersProperty {

  def apply(
    apiKeyAuthParameters: Option[software.amazon.awscdk.services.events.CfnConnection.ApiKeyAuthParametersProperty] = None,
    basicAuthParameters: Option[software.amazon.awscdk.services.events.CfnConnection.BasicAuthParametersProperty] = None,
    invocationHttpParameters: Option[software.amazon.awscdk.services.events.CfnConnection.ConnectionHttpParametersProperty] = None,
    oAuthParameters: Option[software.amazon.awscdk.services.events.CfnConnection.OAuthParametersProperty] = None
  ): software.amazon.awscdk.services.events.CfnConnection.AuthParametersProperty =
    (new software.amazon.awscdk.services.events.CfnConnection.AuthParametersProperty.Builder)
      .apiKeyAuthParameters(apiKeyAuthParameters.orNull)
      .basicAuthParameters(basicAuthParameters.orNull)
      .invocationHttpParameters(invocationHttpParameters.orNull)
      .oAuthParameters(oAuthParameters.orNull)
      .build()
}
